
package gov.va.med.mhv.usermgmt.data.model;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.hibernate.annotations.Type;

import gov.va.med.mhv.common.data.model.AbstractBaseEntity;

@Entity
@Table(name = "USER_PASSWORD_HISTORY")
public class UserPasswordHistory extends AbstractBaseEntity {

	private static final long serialVersionUID = -836141488881774830L;

	@Id
	@Column(name = "USER_PASSWORD_HISTORY_ID")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long userPasswordHistoryId;

	@Column(name = "OPLOCK")
	private Integer oplock;

	@Column(name = "PASSWORD")
	private String password;

	@Column(name = "USER_PROFILE_ID")
	private Long userProfileId;

	@Column(name = "UPDATED_TIME")
	@Temporal(TemporalType.TIMESTAMP)
	private Date updatedTime;

	@Column(name = "TEMP_PASSWORD_FLAG", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean tempPasswordFlag;

	public UserPasswordHistory() {
		
	}
	
	public Long getUserPasswordHistoryId() {

		return userPasswordHistoryId;
	}

	public void setUserPasswordHistoryId(Long userPasswordHistoryId) {

		this.userPasswordHistoryId = userPasswordHistoryId;
	}

	public Integer getOplock() {

		return oplock;
	}

	public void setOplock(Integer oplock) {

		this.oplock = oplock;
	}

	public String getPassword() {

		return password;
	}

	public void setPassword(String password) {

		this.password = password;
	}

	public Long getUserProfileId() {

		return userProfileId;
	}

	public void setUserProfileId(Long userProfileId) {

		this.userProfileId = userProfileId;
	}

	public Date getUpdatedTime() {

		return updatedTime;
	}

	public void setUpdatedTime(Date updatedTime) {

		this.updatedTime = updatedTime;
	}

	public Boolean getTempPasswordFlag() {

		return tempPasswordFlag;
	}

	public void setTempPasswordFlag(Boolean tempPasswordFlag) {

		this.tempPasswordFlag = tempPasswordFlag;
	}
}
